<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProductApiTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        $this->seed(\Database\Seeders\DatabaseSeeder::class);
    }

    public function test_products_index_returns_success(): void
    {
        $response = $this->getJson('/api/v1/products');
        $response->assertStatus(200);
        $response->assertJsonStructure(['data']);
    }

    public function test_products_featured_returns_success(): void
    {
        $response = $this->getJson('/api/v1/products/featured');
        $response->assertStatus(200);
        $response->assertJsonStructure(['data']);
    }

    public function test_product_show_by_slug_returns_404_when_missing(): void
    {
        $response = $this->getJson('/api/v1/products/non-existent-slug');
        $response->assertStatus(404);
    }

    public function test_product_show_by_slug_returns_product_when_exists(): void
    {
        $response = $this->getJson('/api/v1/products/natural-sidr-honey');
        $response->assertStatus(200);
        $response->assertJsonPath('data.slug', 'natural-sidr-honey');
    }
}
