<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class OrderApiTest extends TestCase
{
    use RefreshDatabase;

    public function test_create_order_requires_auth(): void
    {
        $response = $this->postJson('/api/v1/orders', [
            'delivery_address' => 'عمّان',
            'delivery_city' => 'عمّان',
        ]);
        $response->assertStatus(401);
    }

    public function test_orders_index_requires_auth(): void
    {
        $response = $this->getJson('/api/v1/orders');
        $response->assertStatus(401);
    }
}
