<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Hash;
use Tests\TestCase;

class AuthApiTest extends TestCase
{
    use RefreshDatabase;

    public function test_customer_login_returns_token_and_customer(): void
    {
        $response = $this->postJson('/api/v1/auth/login', [
            'name' => 'أحمد محمد',
            'phone' => '0799999999',
        ]);

        $response->assertStatus(200);
        $response->assertJsonStructure([
            'customer' => ['id', 'name', 'phone'],
            'token',
        ]);
        $this->assertDatabaseHas('customers', ['phone' => '0799999999']);
    }

    public function test_customer_login_validation_requires_name_and_phone(): void
    {
        $response = $this->postJson('/api/v1/auth/login', []);
        $response->assertStatus(422);
    }

    public function test_admin_login_returns_token_for_admin_user(): void
    {
        User::create([
            'name' => 'Admin',
            'email' => 'admin@test.com',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'is_active' => true,
        ]);

        $response = $this->postJson('/api/v1/auth/admin/login', [
            'email' => 'admin@test.com',
            'password' => 'password',
        ]);

        $response->assertStatus(200);
        $response->assertJsonStructure(['user', 'token']);
    }

    public function test_admin_login_rejects_invalid_credentials(): void
    {
        $response = $this->postJson('/api/v1/auth/admin/login', [
            'email' => 'admin@test.com',
            'password' => 'wrong',
        ]);
        $response->assertStatus(422);
    }
}
