<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes - Rawabi Nahlah
|--------------------------------------------------------------------------
*/

// Public routes
Route::prefix('v1')->group(function () {

    // Auth
    Route::post('/auth/login', [\App\Http\Controllers\Api\AuthController::class, 'login']);
    Route::post('/auth/register', [\App\Http\Controllers\Api\AuthController::class, 'register']);
    Route::post('/auth/admin/login', [\App\Http\Controllers\Api\AuthController::class, 'adminLogin']);

    // Products (public)
    Route::get('/products', [\App\Http\Controllers\Api\ProductController::class, 'index']);
    Route::get('/products/featured', [\App\Http\Controllers\Api\ProductController::class, 'featured']);
    Route::get('/products/best-sellers', [\App\Http\Controllers\Api\ProductController::class, 'bestSellers']);
    Route::get('/products/search', [\App\Http\Controllers\Api\ProductController::class, 'search']);
    Route::get('/products/{product:slug}', [\App\Http\Controllers\Api\ProductController::class, 'show']);
    Route::get('/products/{product}/reviews', [\App\Http\Controllers\Api\ReviewController::class, 'index']);

    // Categories (public)
    Route::get('/categories', [\App\Http\Controllers\Api\CategoryController::class, 'index']);
    Route::get('/categories/{category:slug}', [\App\Http\Controllers\Api\CategoryController::class, 'show']);
    Route::get('/categories/{category:slug}/products', [\App\Http\Controllers\Api\CategoryController::class, 'products']);

    // Bundles (public)
    Route::get('/bundles', [\App\Http\Controllers\Api\BundleController::class, 'index']);
    Route::get('/bundles/{bundle:slug}', [\App\Http\Controllers\Api\BundleController::class, 'show']);

    // Stories (public)
    Route::get('/stories', [\App\Http\Controllers\Api\StoryController::class, 'index']);

    // Banners (public)
    Route::get('/banners', [\App\Http\Controllers\Api\BannerController::class, 'index']);

    // Popups (public)
    Route::get('/popups/active', [\App\Http\Controllers\Api\PopupController::class, 'active']);

    // Reels (public)
    Route::get('/reels', [\App\Http\Controllers\Api\ReelController::class, 'index']);

    // Pages (public)
    Route::get('/pages/{page:slug}', [\App\Http\Controllers\Api\PageController::class, 'show']);

    // Settings (public)
    Route::get('/settings', [\App\Http\Controllers\Api\SettingController::class, 'index']);
    Route::get('/settings/{key}', [\App\Http\Controllers\Api\SettingController::class, 'show']);

    // SEO
    Route::get('/seo/{type}/{slug}', [\App\Http\Controllers\Api\SeoController::class, 'show']);

    // Delivery zones
    Route::get('/delivery-zones', [\App\Http\Controllers\Api\DeliveryZoneController::class, 'index']);

    // Payment methods
    Route::get('/payment-methods', [\App\Http\Controllers\Api\PaymentMethodController::class, 'index']);

    // Coupon validation
    Route::post('/coupons/validate', [\App\Http\Controllers\Api\CouponController::class, 'validate']);

    // Order tracking (public with order number)
    Route::get('/orders/track/{orderNumber}', [\App\Http\Controllers\Api\OrderController::class, 'track']);

    // Currencies
    Route::get('/currencies', [\App\Http\Controllers\Api\CurrencyController::class, 'index']);

    // Customer authenticated routes
    Route::middleware('auth:sanctum')->group(function () {

        // Auth
        Route::post('/auth/logout', [\App\Http\Controllers\Api\AuthController::class, 'logout']);
        Route::get('/auth/me', [\App\Http\Controllers\Api\AuthController::class, 'me']);

        // Cart
        Route::get('/cart', [\App\Http\Controllers\Api\CartController::class, 'index']);
        Route::post('/cart/items', [\App\Http\Controllers\Api\CartController::class, 'addItem']);
        Route::put('/cart/items/{cartItem}', [\App\Http\Controllers\Api\CartController::class, 'updateItem']);
        Route::delete('/cart/items/{cartItem}', [\App\Http\Controllers\Api\CartController::class, 'removeItem']);
        Route::delete('/cart/clear', [\App\Http\Controllers\Api\CartController::class, 'clear']);

        // Orders
        Route::get('/orders', [\App\Http\Controllers\Api\OrderController::class, 'index']);
        Route::post('/orders', [\App\Http\Controllers\Api\OrderController::class, 'store']);
        Route::get('/orders/{order}', [\App\Http\Controllers\Api\OrderController::class, 'show']);

        // Wishlist
        Route::get('/wishlist', [\App\Http\Controllers\Api\WishlistController::class, 'index']);
        Route::post('/wishlist', [\App\Http\Controllers\Api\WishlistController::class, 'store']);
        Route::delete('/wishlist/{product}', [\App\Http\Controllers\Api\WishlistController::class, 'destroy']);

        // Reviews
        Route::post('/products/{product}/reviews', [\App\Http\Controllers\Api\ReviewController::class, 'store']);

        // Comparisons
        Route::get('/comparisons', [\App\Http\Controllers\Api\ComparisonController::class, 'index']);
        Route::post('/comparisons', [\App\Http\Controllers\Api\ComparisonController::class, 'store']);
        Route::delete('/comparisons/{product}', [\App\Http\Controllers\Api\ComparisonController::class, 'destroy']);

        // Loyalty points
        Route::get('/loyalty', [\App\Http\Controllers\Api\LoyaltyController::class, 'index']);

        // Gift cards
        Route::post('/gift-cards/redeem', [\App\Http\Controllers\Api\GiftCardController::class, 'redeem']);

        // Chat
        Route::get('/chat/conversations', [\App\Http\Controllers\Api\ChatController::class, 'conversations']);
        Route::post('/chat/conversations', [\App\Http\Controllers\Api\ChatController::class, 'createConversation']);
        Route::get('/chat/conversations/{conversation}/messages', [\App\Http\Controllers\Api\ChatController::class, 'messages']);
        Route::post('/chat/conversations/{conversation}/messages', [\App\Http\Controllers\Api\ChatController::class, 'sendMessage']);

        // Notifications
        Route::get('/notifications', [\App\Http\Controllers\Api\NotificationController::class, 'index']);
        Route::put('/notifications/{notification}/read', [\App\Http\Controllers\Api\NotificationController::class, 'markAsRead']);
    });

    // Admin routes
    Route::middleware(['auth:sanctum', 'admin'])->prefix('admin')->group(function () {

        // Dashboard
        Route::get('/dashboard', [\App\Http\Controllers\Api\Admin\DashboardController::class, 'index']);
        Route::get('/dashboard/stats', [\App\Http\Controllers\Api\Admin\DashboardController::class, 'stats']);

        // Products management
        Route::apiResource('products', \App\Http\Controllers\Api\Admin\ProductController::class);
        Route::post('/products/{product}/images', [\App\Http\Controllers\Api\Admin\ProductController::class, 'uploadImage']);
        Route::delete('/products/{product}/images/{image}', [\App\Http\Controllers\Api\Admin\ProductController::class, 'deleteImage']);
        Route::post('/products/{product}/videos', [\App\Http\Controllers\Api\Admin\ProductController::class, 'uploadVideo']);
        Route::put('/products/{product}/toggle', [\App\Http\Controllers\Api\Admin\ProductController::class, 'toggle']);

        // Categories management
        Route::apiResource('categories', \App\Http\Controllers\Api\Admin\CategoryController::class);
        Route::put('/categories/reorder', [\App\Http\Controllers\Api\Admin\CategoryController::class, 'reorder']);

        // Orders management
        Route::apiResource('orders', \App\Http\Controllers\Api\Admin\OrderController::class);
        Route::put('/orders/{order}/status', [\App\Http\Controllers\Api\Admin\OrderController::class, 'updateStatus']);
        Route::post('/orders/{order}/items', [\App\Http\Controllers\Api\Admin\OrderController::class, 'addItem']);
        Route::delete('/orders/{order}/items/{item}', [\App\Http\Controllers\Api\Admin\OrderController::class, 'removeItem']);
        Route::get('/orders/{order}/invoice', [\App\Http\Controllers\Api\Admin\OrderController::class, 'invoice']);
        Route::get('/orders/export/{format}', [\App\Http\Controllers\Api\Admin\OrderController::class, 'export']);

        // Customers management
        Route::apiResource('customers', \App\Http\Controllers\Api\Admin\CustomerController::class)->only(['index', 'show']);
        Route::get('/customers/{customer}/orders', [\App\Http\Controllers\Api\Admin\CustomerController::class, 'orders']);
        Route::get('/customers/{customer}/stats', [\App\Http\Controllers\Api\Admin\CustomerController::class, 'stats']);

        // Coupons management
        Route::apiResource('coupons', \App\Http\Controllers\Api\Admin\CouponController::class);
        Route::get('/coupons/{coupon}/stats', [\App\Http\Controllers\Api\Admin\CouponController::class, 'stats']);

        // Discounts management
        Route::apiResource('discounts', \App\Http\Controllers\Api\Admin\DiscountController::class);

        // Bundles management
        Route::apiResource('bundles', \App\Http\Controllers\Api\Admin\BundleController::class);

        // Banners management
        Route::apiResource('banners', \App\Http\Controllers\Api\Admin\BannerController::class);
        Route::put('/banners/reorder', [\App\Http\Controllers\Api\Admin\BannerController::class, 'reorder']);

        // Stories management
        Route::apiResource('stories', \App\Http\Controllers\Api\Admin\StoryController::class);

        // Popups management
        Route::apiResource('popups', \App\Http\Controllers\Api\Admin\PopupController::class);

        // Reels management
        Route::apiResource('reels', \App\Http\Controllers\Api\Admin\ReelController::class);

        // Pages management
        Route::apiResource('pages', \App\Http\Controllers\Api\Admin\PageController::class);

        // Reviews management
        Route::get('/reviews', [\App\Http\Controllers\Api\Admin\ReviewController::class, 'index']);
        Route::put('/reviews/{review}/approve', [\App\Http\Controllers\Api\Admin\ReviewController::class, 'approve']);
        Route::put('/reviews/{review}/reject', [\App\Http\Controllers\Api\Admin\ReviewController::class, 'reject']);
        Route::put('/reviews/{review}/reply', [\App\Http\Controllers\Api\Admin\ReviewController::class, 'reply']);

        // Delivery zones
        Route::apiResource('delivery-zones', \App\Http\Controllers\Api\Admin\DeliveryZoneController::class);

        // Payment methods
        Route::apiResource('payment-methods', \App\Http\Controllers\Api\Admin\PaymentMethodController::class);

        // Loyalty program
        Route::get('/loyalty/settings', [\App\Http\Controllers\Api\Admin\LoyaltyController::class, 'settings']);
        Route::put('/loyalty/settings', [\App\Http\Controllers\Api\Admin\LoyaltyController::class, 'updateSettings']);
        Route::get('/loyalty/customers', [\App\Http\Controllers\Api\Admin\LoyaltyController::class, 'customers']);

        // Gift cards
        Route::apiResource('gift-cards', \App\Http\Controllers\Api\Admin\GiftCardController::class);

        // Settings
        Route::get('/settings', [\App\Http\Controllers\Api\Admin\SettingController::class, 'index']);
        Route::put('/settings', [\App\Http\Controllers\Api\Admin\SettingController::class, 'update']);
        Route::post('/settings/logo', [\App\Http\Controllers\Api\Admin\SettingController::class, 'uploadLogo']);
        Route::post('/settings/favicon', [\App\Http\Controllers\Api\Admin\SettingController::class, 'uploadFavicon']);
        Route::post('/settings/hero-background', [\App\Http\Controllers\Api\Admin\SettingController::class, 'uploadHeroBackground']);

        // SEO settings
        Route::apiResource('seo', \App\Http\Controllers\Api\Admin\SeoController::class);

        // Users management
        Route::apiResource('users', \App\Http\Controllers\Api\Admin\UserController::class);

        // Chat management
        Route::get('/chat/conversations', [\App\Http\Controllers\Api\Admin\ChatController::class, 'conversations']);
        Route::get('/chat/conversations/{conversation}', [\App\Http\Controllers\Api\Admin\ChatController::class, 'show']);
        Route::post('/chat/conversations/{conversation}/messages', [\App\Http\Controllers\Api\Admin\ChatController::class, 'sendMessage']);
        Route::get('/chat/settings', [\App\Http\Controllers\Api\Admin\ChatController::class, 'settings']);
        Route::put('/chat/settings', [\App\Http\Controllers\Api\Admin\ChatController::class, 'updateSettings']);

        // Currencies
        Route::apiResource('currencies', \App\Http\Controllers\Api\Admin\CurrencyController::class);

        // Reports
        Route::get('/reports/sales', [\App\Http\Controllers\Api\Admin\ReportController::class, 'sales']);
        Route::get('/reports/products', [\App\Http\Controllers\Api\Admin\ReportController::class, 'products']);
        Route::get('/reports/inventory', [\App\Http\Controllers\Api\Admin\ReportController::class, 'inventory']);
        Route::get('/reports/customers', [\App\Http\Controllers\Api\Admin\ReportController::class, 'customers']);
        Route::get('/reports/revenue', [\App\Http\Controllers\Api\Admin\ReportController::class, 'revenue']);
        Route::get('/reports/export/{type}/{format}', [\App\Http\Controllers\Api\Admin\ReportController::class, 'export']);

        // Notifications
        Route::get('/notifications', [\App\Http\Controllers\Api\Admin\NotificationController::class, 'index']);
        Route::put('/notifications/{notification}/read', [\App\Http\Controllers\Api\Admin\NotificationController::class, 'markAsRead']);
        Route::put('/notifications/read-all', [\App\Http\Controllers\Api\Admin\NotificationController::class, 'markAllAsRead']);
    });
});
