<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Convert database and all tables to utf8mb4 for proper Arabic/Unicode support.
     */
    public function up(): void
    {
        $database = config('database.connections.mysql.database');

        DB::statement("ALTER DATABASE `{$database}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");

        $tables = [
            'banners',
            'bundle_items',
            'bundles',
            'cache',
            'cache_locks',
            'cart_items',
            'carts',
            'categories',
            'chat_conversations',
            'chat_messages',
            'comparisons',
            'coupon_usage',
            'coupons',
            'currencies',
            'customers',
            'delivery_zones',
            'discounts',
            'failed_jobs',
            'gift_cards',
            'inventory_logs',
            'job_batches',
            'jobs',
            'loyalty_points',
            'migrations',
            'notifications',
            'order_items',
            'order_statuses',
            'orders',
            'pages',
            'payment_methods',
            'personal_access_tokens',
            'popups',
            'product_images',
            'product_videos',
            'product_weights',
            'products',
            'reels',
            'reviews',
            'seo_meta',
            'sessions',
            'settings',
            'stories',
            'users',
            'weight_units',
            'wishlists',
        ];

        foreach ($tables as $table) {
            try {
                DB::statement("ALTER TABLE `{$table}` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            } catch (\Exception $e) {
                // Table might not exist yet, skip
            }
        }
    }

    /**
     * Reverse the migration.
     */
    public function down(): void
    {
        // No safe reverse - charset conversion is typically one-way
    }
};
