<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class WeightUnit extends Model
{
    use HasFactory;

    protected $fillable = [
        'name_ar',
        'name_en',
        'abbreviation_ar',
        'abbreviation_en',
    ];

    public function productWeights(): HasMany
    {
        return $this->hasMany(ProductWeight::class);
    }
}
