<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GiftCard extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'amount',
        'balance',
        'purchaser_customer_id',
        'recipient_name',
        'recipient_phone',
        'message',
        'is_active',
        'used_at',
        'expires_at',
    ];

    protected function casts(): array
    {
        return [
            'amount' => 'decimal:2',
            'balance' => 'decimal:2',
            'is_active' => 'boolean',
            'used_at' => 'datetime',
            'expires_at' => 'datetime',
        ];
    }
}
