<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Bundle extends Model
{
    use HasFactory;

    protected $fillable = [
        'name_ar',
        'name_en',
        'slug',
        'description_ar',
        'description_en',
        'image',
        'original_price',
        'bundle_price',
        'savings_amount',
        'is_active',
        'starts_at',
        'expires_at',
        'sort_order',
    ];

    protected function casts(): array
    {
        return [
            'original_price' => 'decimal:2',
            'bundle_price' => 'decimal:2',
            'savings_amount' => 'decimal:2',
            'is_active' => 'boolean',
            'starts_at' => 'datetime',
            'expires_at' => 'datetime',
        ];
    }

    public function items(): HasMany
    {
        return $this->hasMany(BundleItem::class);
    }
}
