<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Setting;

class SettingController extends Controller
{
    /**
     * All public settings.
     */
    public function index()
    {
        $settings = Setting::all()
            ->pluck('value', 'key');

        return response()->json(['data' => $settings]);
    }

    /**
     * Single setting by key.
     */
    public function show(string $key)
    {
        $setting = Setting::where('key', $key)
            ->first();

        if (!$setting) {
            return response()->json(['message' => 'الإعداد غير موجود'], 404);
        }

        return response()->json(['data' => [
            'key' => $setting->key,
            'value' => $setting->value,
        ]]);
    }
}
