<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Seo;

class SeoController extends Controller
{
    /**
     * SEO meta data for an entity.
     */
    public function show(string $type, string $slug)
    {
        $allowedTypes = ['product', 'category', 'page', 'bundle'];

        if (!in_array($type, $allowedTypes)) {
            return response()->json(['message' => 'نوع غير صالح'], 422);
        }

        $seo = Seo::where('seoable_type', $this->resolveModelType($type))
            ->whereHas('seoable', function ($q) use ($slug) {
                $q->where('slug', $slug);
            })
            ->first();

        if (!$seo) {
            // Fallback: try to get default SEO
            $seo = Seo::where('seoable_type', $type)
                ->where('seoable_id', 0)
                ->first();
        }

        return response()->json(['data' => $seo]);
    }

    /**
     * Resolve model class from type string.
     */
    private function resolveModelType(string $type): string
    {
        return match ($type) {
            'product' => 'App\\Models\\Product',
            'category' => 'App\\Models\\Category',
            'page' => 'App\\Models\\Page',
            'bundle' => 'App\\Models\\Bundle',
            default => $type,
        };
    }
}
