<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Reel;

class ReelController extends Controller
{
    /**
     * Active reels.
     */
    public function index()
    {
        $reels = Reel::where('is_active', true)
            ->with(['product:id,name_ar,name_en,slug'])
            ->orderBy('sort_order', 'asc')
            ->orderBy('created_at', 'desc')
            ->get();

        return response()->json(['data' => $reels]);
    }
}
