<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Popup;

class PopupController extends Controller
{
    /**
     * Currently active popup.
     */
    public function active()
    {
        $popup = Popup::where('is_active', true)
            ->where(function ($q) {
                $q->whereNull('start_date')->orWhere('start_date', '<=', now());
            })
            ->where(function ($q) {
                $q->whereNull('end_date')->orWhere('end_date', '>=', now());
            })
            ->orderBy('created_at', 'desc')
            ->first();

        if (!$popup) {
            return response()->json(['data' => null]);
        }

        return response()->json(['data' => $popup]);
    }
}
