<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    /**
     * Customer's notifications.
     */
    public function index(Request $request)
    {
        $notifications = Notification::where('notifiable_type', 'App\\Models\\Customer')
            ->where('notifiable_id', $request->user()->id)
            ->orderBy('created_at', 'desc')
            ->paginate($request->get('per_page', 20));

        $unreadCount = Notification::where('notifiable_type', 'App\\Models\\Customer')
            ->where('notifiable_id', $request->user()->id)
            ->whereNull('read_at')
            ->count();

        return response()->json([
            'data' => $notifications,
            'unread_count' => $unreadCount,
        ]);
    }

    /**
     * Mark notification as read.
     */
    public function markAsRead(Request $request, Notification $notification)
    {
        if ($notification->notifiable_id !== $request->user()->id ||
            $notification->notifiable_type !== 'App\\Models\\Customer') {
            return response()->json(['message' => 'غير مصرح'], 403);
        }

        $notification->update(['read_at' => now()]);

        return response()->json([
            'message' => 'تم تحديد الإشعار كمقروء',
        ]);
    }
}
