<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\LoyaltyPoint;
use Illuminate\Http\Request;

class LoyaltyController extends Controller
{
    /**
     * Customer's loyalty points balance and history.
     */
    public function index(Request $request)
    {
        $customer = $request->user();

        $totalEarned = LoyaltyPoint::where('customer_id', $customer->id)
            ->where('type', 'earned')
            ->sum('points');

        $totalRedeemed = LoyaltyPoint::where('customer_id', $customer->id)
            ->where('type', 'redeemed')
            ->sum('points');

        $balance = $totalEarned - $totalRedeemed;

        $history = LoyaltyPoint::where('customer_id', $customer->id)
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        return response()->json([
            'balance' => $balance,
            'total_earned' => $totalEarned,
            'total_redeemed' => $totalRedeemed,
            'history' => $history,
        ]);
    }
}
