<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Currency;

class CurrencyController extends Controller
{
    /**
     * Active currencies.
     */
    public function index()
    {
        $currencies = Currency::where('is_active', true)
            ->orderBy('is_default', 'desc')
            ->orderBy('name_ar', 'asc')
            ->get();

        return response()->json(['data' => $currencies]);
    }
}
