<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    /**
     * All active categories with children and product counts.
     */
    public function index()
    {
        $categories = Category::where('is_active', true)
            ->withCount(['children', 'products' => function ($q) {
                $q->where('is_active', true);
            }])
            ->orderBy('sort_order', 'asc')
            ->orderBy('name_ar', 'asc')
            ->get();

        return response()->json(['data' => $categories]);
    }

    /**
     * Single category details.
     */
    public function show(Category $category)
    {
        if (!$category->is_active) {
            return response()->json(['message' => 'التصنيف غير متوفر'], 404);
        }

        $category->load(['children' => function ($q) {
            $q->where('is_active', true)->orderBy('sort_order');
        }]);

        $category->loadCount(['products' => function ($q) {
            $q->where('is_active', true);
        }]);

        return response()->json(['data' => $category]);
    }

    /**
     * Products within a category.
     */
    public function products(Request $request, Category $category)
    {
        $products = $category->products()
            ->with(['weights.weightUnit', 'images', 'category'])
            ->where('is_active', true)
            ->orderBy('sort_order', 'asc')
            ->orderBy('created_at', 'desc')
            ->paginate($request->get('per_page', 15));

        return response()->json($products);
    }
}
