<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Bundle;

class BundleController extends Controller
{
    /**
     * Active bundles with their items.
     */
    public function index()
    {
        $bundles = Bundle::with(['items.product.images', 'items.productWeight.weightUnit'])
            ->where('is_active', true)
            ->where(function ($q) {
                $q->whereNull('start_date')->orWhere('start_date', '<=', now());
            })
            ->where(function ($q) {
                $q->whereNull('end_date')->orWhere('end_date', '>=', now());
            })
            ->orderBy('sort_order', 'asc')
            ->get();

        return response()->json(['data' => $bundles]);
    }

    /**
     * Single bundle with items and products.
     */
    public function show(Bundle $bundle)
    {
        if (!$bundle->is_active) {
            return response()->json(['message' => 'الباقة غير متوفرة'], 404);
        }

        $bundle->load(['items.product.images', 'items.product.weights.weightUnit', 'items.productWeight.weightUnit']);

        return response()->json(['data' => $bundle]);
    }
}
